<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class PaymentController extends Controller
{
    public function index()
    {
        return view('admin.payments.index', [
            'pageTitle' => 'Pagos - UrbanOSS'
        ]);
    }
    
    public function create()
    {
        return view('admin.payments.create', [
            'pageTitle' => 'Nuevo Pago - UrbanOSS'
        ]);
    }
    
    public function store(Request $request)
    {
        return redirect()->route('admin.pagos.index')
            ->with('success', 'Pago registrado');
    }
    
    public function show($id)
    {
        return view('admin.payments.show', [
            'pageTitle' => 'Detalle Pago - UrbanOSS',
            'id' => $id
        ]);
    }
    
    public function edit($id)
    {
        return view('admin.payments.edit', [
            'pageTitle' => 'Editar Pago - UrbanOSS',
            'id' => $id
        ]);
    }
    
    public function update(Request $request, $id)
    {
        return redirect()->route('admin.pagos.index')
            ->with('success', 'Pago actualizado');
    }
    
    public function destroy($id)
    {
        return back()->with('success', 'Pago eliminado');
    }
    
    public function approve($id)
    {
        return back()->with('success', 'Pago aprobado');
    }
    
    public function reject($id)
    {
        return back()->with('success', 'Pago rechazado');
    }
    
    public function generateCodes()
    {
        return back()->with('success', 'Códigos de pago generados');
    }
}
