<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class ReservationController extends Controller
{
    public function index()
    {
        return view('admin.reservas.index', [
            'pageTitle' => 'Reservas - UrbanOSS'
        ]);
    }
    
    public function create()
    {
        return view('admin.reservas.create', [
            'pageTitle' => 'Nueva Reserva - UrbanOSS'
        ]);
    }
    
    public function store(Request $request)
    {
        return redirect()->route('admin.reservas.index')
            ->with('success', 'Reserva creada');
    }
    
    public function show($id)
    {
        return view('admin.reservas.show', [
            'pageTitle' => 'Detalle Reserva - UrbanOSS',
            'id' => $id
        ]);
    }
    
    public function edit($id)
    {
        return view('admin.reservas.edit', [
            'pageTitle' => 'Editar Reserva - UrbanOSS',
            'id' => $id
        ]);
    }
    
    public function update(Request $request, $id)
    {
        return redirect()->route('admin.reservas.index')
            ->with('success', 'Reserva actualizada');
    }
    
    public function destroy($id)
    {
        return back()->with('success', 'Reserva eliminada');
    }
    
    public function approve($id)
    {
        return back()->with('success', 'Reserva aprobada');
    }
}
