<?php
namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class RegisterController extends Controller
{
    public function showRegistrationForm()
    {
        return view('auth.register', [
            'pageTitle' => 'Registro - UrbanOSS'
        ]);
    }
    
    public function register(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users',
            'password' => 'required|string|min:8|confirmed',
        ]);
        
        $user = User::create([
            'name' => $request->name,
            'email' => $request->email,
            'password' => Hash::make($request->password),
            'role' => 'propietario',
            'estado' => 'pendiente'
        ]);
        
        Log::info('Usuario registrado', ['user_id' => $user->id]);
        
        return redirect()->route('login')
            ->with('status', 'success')
            ->with('message', 'Registro exitoso. Pendiente de aprobación.');
    }
    
    public function sendResetLinkEmail(Request $request)
    {
        // Temporal - siempre devuelve éxito
        return back()->with('status', 'Enlace de recuperación enviado (modo desarrollo)');
    }
    
    public function reset(Request $request)
    {
        // Temporal - siempre devuelve éxito
        return redirect()->route('login')
            ->with('status', 'success')
            ->with('message', 'Contraseña restablecida exitosamente');
    }
}
