<?php
namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class ReclamacionController extends Controller
{
    public function index()
    {
        return view('resident.reclamaciones.index', [
            'pageTitle' => 'Reclamaciones - UrbanOSS'
        ]);
    }
    
    public function create()
    {
        return view('resident.reclamaciones.create', [
            'pageTitle' => 'Nueva Reclamación - UrbanOSS'
        ]);
    }
    
    public function store(Request $request)
    {
        return redirect()->route('resident.reclamaciones.index')
            ->with('success', 'Reclamación enviada');
    }
    
    public function show($id)
    {
        return view('resident.reclamaciones.show', [
            'pageTitle' => 'Detalle Reclamación - UrbanOSS',
            'id' => $id
        ]);
    }
    
    public function edit($id)
    {
        return view('resident.reclamaciones.edit', [
            'pageTitle' => 'Editar Reclamación - UrbanOSS',
            'id' => $id
        ]);
    }
    
    public function update(Request $request, $id)
    {
        return redirect()->route('resident.reclamaciones.index')
            ->with('success', 'Reclamación actualizada');
    }
    
    public function destroy($id)
    {
        return back()->with('success', 'Reclamación eliminada');
    }
}
