<?php
namespace App\Http\Controllers\Security;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class IncidenteController extends Controller
{
    public function index()
    {
        return view('security.incidentes.index', [
            'pageTitle' => 'Incidentes - UrbanOSS'
        ]);
    }
    
    public function create()
    {
        return view('security.incidentes.create', [
            'pageTitle' => 'Nuevo Incidente - UrbanOSS'
        ]);
    }
    
    public function store(Request $request)
    {
        return redirect()->route('security.incidentes.index')
            ->with('success', 'Incidente registrado');
    }
    
    public function show($id)
    {
        return view('security.incidentes.show', [
            'pageTitle' => 'Detalle Incidente - UrbanOSS',
            'id' => $id
        ]);
    }
    
    public function edit($id)
    {
        return view('security.incidentes.edit', [
            'pageTitle' => 'Editar Incidente - UrbanOSS',
            'id' => $id
        ]);
    }
    
    public function update(Request $request, $id)
    {
        return redirect()->route('security.incidentes.index')
            ->with('success', 'Incidente actualizado');
    }
    
    public function destroy($id)
    {
        return back()->with('success', 'Incidente eliminado');
    }
}
