<?php
// ARCHIVO: app/Providers/UrbanOSSServiceProvider.php (VERSIÓN SIMPLIFICADA)

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

class UrbanOSSServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        // Registrar configuraciones de UrbanOSS
        $this->mergeConfigFrom(
            __DIR__.'/../../config/urbanoss.php', 'urbanoss'
        );
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        // Publicar configuraciones (solo si se ejecuta artisan vendor:publish)
        if ($this->app->runningInConsole()) {
            $this->publishes([
                __DIR__.'/../../config/urbanoss.php' => config_path('urbanoss.php'),
            ], 'urbanoss-config');
        }
    }
}