<?php
// ARCHIVO: #3 - database/migrations/2024_12_07_000001_add_deleted_at_to_condominios_table.php
// VERSIÓN: 1.0
// PREDECESORES: Tabla condominios existente
// DESCRIPCIÓN: Agrega columna deleted_at para SoftDeletes en condominios
// RUTA EXACTA: database/migrations/2024_12_07_000001_add_deleted_at_to_condominios_table.php
// COMPATIBILIDAD: Laravel 11.47

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('condominios', function (Blueprint $table) {
            if (!Schema::hasColumn('condominios', 'deleted_at')) {
                $table->timestamp('deleted_at')->nullable()->after('updated_at');
            }
        });
    }

    public function down(): void
    {
        Schema::table('condominios', function (Blueprint $table) {
            if (Schema::hasColumn('condominios', 'deleted_at')) {
                $table->dropColumn('deleted_at');
            }
        });
    }
};