import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';

export default defineConfig({
    plugins: [
        laravel({
            input: [
                'resources/css/app.css',
                'resources/js/app.js'
            ],
            refresh: [
                'resources/views/**/*.blade.php',
                'app/**/*.php',
                'routes/**/*.php'
            ],
        }),
    ],
    server: {
        host: '0.0.0.0',
        port: 5173,
        hmr: {
            host: 'localhost',
        },
    },
    build: {
        manifest: true,
        outDir: 'public/build',
        rollupOptions: {
            external: [], // No externalizar nada, todo se incluye
            output: {
                entryFileNames: 'assets/[name].[hash].js',
                chunkFileNames: 'assets/[name].[hash].js',
                assetFileNames: 'assets/[name].[hash].[ext]'
            }
        },
        commonjsOptions: {
            transformMixedEsModules: true
        }
    },
    resolve: {
        alias: {
            '@': '/resources/js'
        }
    },
    optimizeDeps: {
        include: ['jquery', 'alpinejs']
    }
});